@php
    $plan = App\Models\Utility::getChatGPTSettings();
@endphp

{{ Form::open(['url' => 'warning', 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
<div class="modal-body">

    @if ($plan->enable_chatgpt == 'on')
    <div class="card-footer text-end">
        <a href="#" class="btn btn-sm btn-primary" data-size="medium" data-ajax-popup-over="true" data-url="{{ route('generate', ['warning']) }}"
            data-bs-toggle="tooltip" data-bs-placement="top" title="{{ __('Generate') }}"
            data-title="{{ __('Generate Content With AI') }}">
            <i class="fas fa-robot"></i>{{ __(' Generate With AI') }}
        </a>
    </div>
    @endif

    <div class="row">
        @if (\Auth::user()->type != 'employee')
            <div class="form-group col-md-6 col-lg-6">
                {{ Form::label('warning_by', __('Warning By'), ['class' => 'col-form-label']) }}<x-required></x-required>
                {{ Form::select('warning_by', $employees, null, ['class' => 'form-control','id'=>'warning_by', 'required' => 'required','placeholder' => __('Select Employee'),]) }}
                <div class="text-xs mt-1">
                    {{ __('Create employee.') }} <a href="{{ route('employee.index') }}"><b>{{ __('Click here') }}</b></a>
                </div>
            </div>
        @endif
        <div class="form-group col-md-6 col-lg-6">
            {{ Form::label('warning_to', __('Warning To'), ['class' => 'col-form-label']) }}<x-required></x-required>
            {{ Form::select('warning_to', $employees, null, ['class' => 'form-control' ,'id'=>'warning_to','required' => 'required','placeholder' => __('Select Employee'),]) }}
            <div class="text-xs mt-1">
                {{ __('Create employee.') }} <a href="{{ route('employee.index') }}"><b>{{ __('Click here') }}</b></a>
            </div>
        </div>
        <div class="form-group col-md-6 col-lg-6">
            {{ Form::label('subject', __('Subject'), ['class' => 'col-form-label']) }}<x-required></x-required>
            {{ Form::text('subject', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Enter Subject')]) }}
        </div>
        <div class="form-group col-md-6 col-lg-6">
            {{ Form::label('warning_date', __('Warning Date'), ['class' => 'col-form-label']) }}<x-required></x-required>
            {{ Form::text('warning_date', null, ['class' => 'form-control d_week current_date', 'autocomplete' => 'off' ,'required' => 'required']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('description', __('Description'), ['class' => 'col-form-label']) }}<x-required></x-required>
            {{ Form::textarea('description', null, ['class' => 'form-control', 'placeholder' => __('Enter Description') ,'rows' => '3' ,'required' => 'required']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="Cancel" class="btn btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Create') }}" class="btn btn-primary">
</div>

{{ Form::close() }}

<script>
    $(document).ready(function() {
        var now = new Date();
        var month = (now.getMonth() + 1);
        var day = now.getDate();
        if (month < 10) month = "0" + month;
        if (day < 10) day = "0" + day;
        var today = now.getFullYear() + '-' + month + '-' + day;
        $('.current_date').val(today);
    });
</script>
